% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{use.package}
\alias{use.package}
\title{Use optional package}
\usage{
use.package(package, version = "1.9.8"[package == "data.table"],
  use = getOption("h2o.use.data.table", FALSE)[package == "data.table"])
}
\arguments{
\item{package}{character scalar name of a package that we Suggests or Enhances on.}

\item{version}{character scalar required version of a package.}

\item{use}{logical scalar, extra escape option, to be used as global option.}
}
\description{
Testing availability of optional package, its version, and extra global default.
This function is used internally. It is exported and documented because user can
control behavior of the function by global option.
}
\details{
We use this function to control csv read/write with optional \link[data.table]{data.table} package.
Currently data.table is disabled by default, to enable it set \code{options("h2o.use.data.table"=TRUE)}.
It is possible to control just \code{\link[data.table]{fread}} or \code{\link[data.table]{fwrite}} with \code{options("h2o.fread"=FALSE, "h2o.fwrite"=FALSE)}.
\code{h2o.fread} and \code{h2o.fwrite} options are not handled in this function but next to \emph{fread} and \emph{fwrite} calls.
}
\examples{
op <- options("h2o.use.data.table" = TRUE)
if (use.package("data.table")) {
  cat("optional package data.table 1.9.8+ is available\\n")
} else {
  cat("optional package data.table 1.9.8+ is not available\\n")
}
options(op)
}
\seealso{
\code{\link{as.h2o.data.frame}}, \code{\link{as.data.frame.H2OFrame}}
}
