% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.table}
\alias{h2o.table}
\alias{table.H2OFrame}
\title{Cross Tabulation and Table Creation in H2O}
\usage{
h2o.table(x, y = NULL, dense = TRUE)

table.H2OFrame(x, y = NULL, dense = TRUE)
}
\arguments{
\item{x}{An H2OFrame object with at most two columns.}

\item{y}{An H2OFrame similar to x, or \code{NULL}.}

\item{dense}{A logical for dense representation, which lists only non-zero counts, 1 combination per row. Set to 
FALSE to expand counts across all combinations.}
}
\value{
Returns a tabulated H2OFrame object.
}
\description{
Uses the cross-classifying factors to build a table of counts at each combination of factor levels.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath, destination_frame = "prostate.hex")
summary(prostate.hex)

# Counts of the ages of all patients
head(h2o.table(prostate.hex[,3]))
h2o.table(prostate.hex[,3])

# Two-way table of ages (rows) and race (cols) of all patients
head(h2o.table(prostate.hex[,c(3,4)]))
h2o.table(prostate.hex[,c(3,4)])
}
}
