% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/connection.R
\name{h2o.init}
\alias{h2o.init}
\title{Initialize and Connect to H2O}
\usage{
h2o.init(ip = "localhost", port = 54321, startH2O = TRUE,
  forceDL = FALSE, enable_assertions = TRUE, license = NULL,
  nthreads = -1, max_mem_size = NULL, min_mem_size = NULL,
  ice_root = tempdir(), strict_version_check = TRUE,
  proxy = NA_character_, https = FALSE, insecure = FALSE,
  username = NA_character_, password = NA_character_,
  cookies = NA_character_, context_path = NA_character_,
  ignore_config = FALSE, extra_classpath = NULL)
}
\arguments{
\item{ip}{Object of class \code{character} representing the IP address of the server where H2O is running.}

\item{port}{Object of class \code{numeric} representing the port number of the H2O server.}

\item{startH2O}{(Optional) A \code{logical} value indicating whether to try to start H2O from R if no connection with H2O is detected. This is only possible if \code{ip = "localhost"} or \code{ip = "127.0.0.1"}.  If an existing connection is detected, R does not start H2O.}

\item{forceDL}{(Optional) A \code{logical} value indicating whether to force download of the H2O executable. Defaults to FALSE, so the executable will only be downloaded if it does not already exist in the h2o R library resources directory \code{h2o/java/h2o.jar}.  This value is only used when R starts H2O.}

\item{enable_assertions}{(Optional) A \code{logical} value indicating whether H2O should be launched with assertions enabled. Used mainly for error checking and debugging purposes.  This value is only used when R starts H2O.}

\item{license}{(Optional) A \code{character} string value specifying the full path of the license file.  This value is only used when R starts H2O.}

\item{nthreads}{(Optional) Number of threads in the thread pool.  This relates very closely to the number of CPUs used. -1 means use all CPUs on the host (Default).  A positive integer specifies the number of CPUs directly.  This value is only used when R starts H2O.}

\item{max_mem_size}{(Optional) A \code{character} string specifying the maximum size, in bytes, of the memory allocation pool to H2O. This value must a multiple of 1024 greater than 2MB. Append the letter m or M to indicate megabytes, or g or G to indicate gigabytes.  This value is only used when R starts H2O.}

\item{min_mem_size}{(Optional) A \code{character} string specifying the minimum size, in bytes, of the memory allocation pool to H2O. This value must a multiple of 1024 greater than 2MB. Append the letter m or M to indicate megabytes, or g or G to indicate gigabytes.  This value is only used when R starts H2O.}

\item{ice_root}{(Optional) A directory to handle object spillage. The defaul varies by OS.}

\item{strict_version_check}{(Optional) Setting this to FALSE is unsupported and should only be done when advised by technical support.}

\item{proxy}{(Optional) A \code{character} string specifying the proxy path.}

\item{https}{(Optional) Set this to TRUE to use https instead of http.}

\item{insecure}{(Optional) Set this to TRUE to disable SSL certificate checking.}

\item{username}{(Optional) Username to login with.}

\item{password}{(Optional) Password to login with.}

\item{cookies}{(Optional) Vector(or list) of cookies to add to request.}

\item{context_path}{(Optional) The last part of connection URL: http://<ip>:<port>/<context_path>}

\item{ignore_config}{(Optional) A \code{logical} value indicating whether a search for a .h2oconfig file should be conducted or not. Default value is FALSE.}

\item{extra_classpath}{(Optional) A vector of paths to libraries to be added to the Java classpath when H2O is started from R.}
}
\value{
this method will load it and return a \code{H2OConnection} object containing the IP address and port number of the H2O server.
}
\description{
Attempts to start and/or connect to and H2O instance.
}
\details{
By default, this method first checks if an H2O instance is connectible. If it cannot connect and \code{start = TRUE} with \code{ip = "localhost"}, it will attempt to start and instance of H2O at localhost:54321.
If an open ip and port of your choice are passed in, then this method will attempt to start an H2O instance at that specified ip  port.

When initializing H2O locally, this method searches for h2o.jar in the R library resources (\code{system.file("java", "h2o.jar", package = "h2o")}), and if the file does not exist, it will automatically attempt to download the correct version from Amazon S3. The user must have Internet access for this process to be successful.

Once connected, the method checks to see if the local H2O R package version matches the version of H2O running on the server. If there is a mismatch and the user indicates she wishes to upgrade, it will remove the local H2O R package and download/install the H2O R package from the server.
}
\note{
Users may wish to manually upgrade their package (rather than waiting until being prompted), which requires
that they fully uninstall and reinstall the H2O package, and the H2O client package. You must unload packages running
in the environment before upgrading. It's recommended that users restart R or R studio after upgrading
}
\examples{
\dontrun{
# Try to connect to a local H2O instance that is already running.
# If not found, start a local H2O instance from R with the default settings.
h2o.init()

# Try to connect to a local H2O instance.
# If not found, raise an error.
h2o.init(startH2O = FALSE)

# Try to connect to a local H2O instance that is already running.
# If not found, start a local H2O instance from R with 5 gigabytes of memory.
h2o.init(max_mem_size = "5g")

# Try to connect to a local H2O instance that is already running.
# If not found, start a local H2O instance from R that uses 5 gigabytes of memory.
h2o.init(max_mem_size = "5g")
}
}
\seealso{
\href{http://h2o-release.s3.amazonaws.com/h2o-dev/rel-shannon/2/docs-website/h2o-r/h2o_package.pdf}{H2O R package documentation} for more details. \code{\link{h2o.shutdown}} for shutting down from R.
}

