\name{h2o.getGLMLambdaModel}
\alias{h2o.getGLMLambdaModel}
\title{
Get H2O GLM Model for Specific Lambda
}
\description{
Retrieve the H2O GLM model built using a specific value of lambda from a lambda search.
}
\usage{
  h2o.getGLMLambdaModel(model, lambda)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{An \code{\linkS4class{H2OGLMModel}} object generated by \code{h2o.glm} with lambda search enabled.}
  \item{lambda}{The specific value of lambda for which model to retrieve. If that lambda was not include in or saved during the search, the method throws an error.}
  }
\value{
Returns an object of class \code{\linkS4class{H2OGLMModel}}.
}
\examples{
\dontrun{
library(h2o)
localH2O = h2o.init()
prosPath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.importFile(localH2O, path = prosPath)
prostate.srch = h2o.glm(x = 3:9, y = 2, data = prostate.hex, family = "binomial", 
  nlambda = 3, lambda_search = TRUE, nfolds = 0)
random_lambda = sample(prostate.srch@model$params$lambda_all, 1)
random_model = h2o.getGLMLambdaModel(prostate.srch, random_lambda)
}
}
