% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_trip_length.R
\name{get_trip_length}
\alias{get_trip_length}
\title{Get trip length}
\usage{
get_trip_length(
  gtfs,
  trip_id = NULL,
  file = NULL,
  unit = "km",
  sort_sequence = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A character vector including the \code{trip_id}s to have their
length calculated If \code{NULL} (the default), the function calculates the
length of each \code{trip_id} in the GTFS.}

\item{file}{A character vector specifying the file from which lengths should
be calculated (either one of or both \code{shapes} and \code{stop_times}). If \code{NULL}
(the default), the function attempts to calculate the lengths from both
files, but only raises an error if none of the files exist.}

\item{unit}{A string representing the unit in which lengths are desired.
Either \code{"km"} (the default) or \code{"m"}.}

\item{sort_sequence}{A logical specifying whether to sort shapes and
timetables by \code{shape_pt_sequence} and \code{stop_sequence}, respectively.
Defaults to \code{FALSE}, otherwise spec-compliant feeds, in which
shape/timetables points are already ordered by
\code{shape_pt_sequence}/\code{stop_sequence}, would be penalized through longer
processing times. Lengths calculated from trip trajectories generated with
unordered sequences do not correctly depict the actual trip lengths.}
}
\value{
A \code{data.table} containing the length of each specified trip.
}
\description{
Returns the length of each specified \code{trip_id}, based either on the \code{shapes}
or the \code{stop_times} file (or both).
}
\section{Details}{

Please check \code{\link[=get_trip_geometry]{get_trip_geometry()}} documentation to understand how geometry
generation, and consequently length calculation, differs depending on the
chosen file.
}

\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

trip_length <- get_trip_length(gtfs)
head(trip_length)

# the above is identical to
trip_length <- get_trip_length(gtfs, file = c("shapes", "stop_times"))
head(trip_length)

trip_ids <- c("CPTM L07-0", "2002-10-0")
trip_length <- get_trip_length(gtfs, trip_id = trip_ids)
trip_length

}
