% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parent_station.R
\name{get_parent_station}
\alias{get_parent_station}
\title{Get parent stations recursively}
\usage{
get_parent_station(gtfs, stop_id)
}
\arguments{
\item{gtfs}{A GTFS object as created by \code{\link{read_gtfs}}.}

\item{stop_id}{A string vector including the \code{stop_id}s to have their
parents returned.}
}
\value{
A \code{data.table} containing the \code{stop_id}s and their
\code{parent_station}s. If a stop doesn't have a parent, its
\code{parent_station} is \code{""}.
}
\description{
Returns the (recursive) parent stations of each specified \code{stop_id}.
Recursive in this context means it returns all parents' parents (i.e. first
parents, then parents' parents, and then their parents, and so on).
}
\examples{
data_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

parents <- get_parent_station(gtfs, "N3")
parents

parents <- get_parent_station(gtfs, c("B1", "B2"))
parents

}
