% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_header.R
\name{img_header}
\alias{img_header}
\title{Add images as the column label for a table}
\usage{
img_header(
  label,
  img_url,
  height = 60,
  font_size = 12,
  palette = c("black", "black")
)
}
\arguments{
\item{label}{A string indicating the label of the column.}

\item{img_url}{A string for the image url.}

\item{height}{A number indicating the height of the image in pixels.}

\item{font_size}{The font size of the label in pixels.}

\item{palette}{A vector of two colors, indictating the bottom border color and the text color.}
}
\value{
HTML string
}
\description{
Add images as the column label for a table
}
\examples{
example_img <- img_header(
  "Luka Doncic",
  "https://secure.espn.com/combiner/i?img=/i/headshots/nba/players/full/3945274.png",
  height = 60,
  font_size = 14
)
}
