% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_stubhead}
\alias{tab_stubhead}
\title{Add label text to the stubhead}
\usage{
tab_stubhead(data, label)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{label}{The text to be used as the stubhead label We can optionally use
the \code{\link[=md]{md()}} and \code{\link[=html]{html()}} functions to style the text as Markdown or to
retain HTML elements in the text.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add a label to the stubhead of a \strong{gt} table. The stubhead is the lone
element that is positioned left of the column labels, and above the stub. If
a stub does not exist, then there is no stubhead (so no change will be made
when using this function in that case). We have the flexibility to use
Markdown formatting for the stubhead label. Furthermore, if the table is
intended for HTML output, we can use HTML for the stubhead label.
}
\section{Examples}{


Use \code{\link{gtcars}} to create a \strong{gt} table. With \code{tab_stubhead()} we can add a
stubhead label. This appears in the top-left and can be used to describe what
is in the stub.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars \%>\%
  dplyr::select(model, year, hp, trq) \%>\%
  dplyr::slice(1:5) \%>\%
  gt(rowname_col = "model") \%>\%
  tab_stubhead(label = "car")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_stubhead_1.png" alt="This image of a table was generated from the first code example in the `tab_stubhead()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-5
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_style_body}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
