% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substitution.R
\name{sub_zero}
\alias{sub_zero}
\title{Substitute zero values in the table body}
\usage{
sub_zero(data, columns = everything(), rows = everything(), zero_text = "nil")
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{zero_text}{The text to be used in place of zero values in the rendered
table.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Wherever there is numerical data that are zero in value, replacement text may
be better for explanatory purposes. The \code{sub_zero()} function allows for this
replacement through its \code{zero_text} argument.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the Arguments section for more information on this.
}
\section{Examples}{


Let's generate a simple, single-column tibble that contains an assortment of
values that could potentially undergo some substitution.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(num = c(10^(-1:2), 0, 0, 10^(4:6)))

tbl
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 9 × 1
##         num
##       <dbl>
## 1       0.1
## 2       1  
## 3      10  
## 4     100  
## 5       0  
## 6       0  
## 7   10000  
## 8  100000  
## 9 1000000
}\if{html}{\out{</div>}}

With this table, the zero values in will be given replacement text with a
single call of \code{sub_zero()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\%
  gt() \%>\%
  fmt_number(columns = num) \%>\%
  sub_zero()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_sub_zero_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

3-17
}

\seealso{
Other Format Data: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{text_transform}()}
}
\concept{Format Data}
