% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_locales}
\alias{info_locales}
\title{View a table with info on supported locales}
\usage{
info_locales(begins_with = NULL)
}
\arguments{
\item{begins_with}{Providing a single letter will filter locales to only
those that begin with that letter in their base locale ID. The default
(\code{NULL}) will produce a table with all locales displayed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Many of the \verb{fmt_*()} functions have a \code{locale} argument that makes
locale-based formatting easier. The table generated by the \code{info_locales()}
function provides a quick reference to all the available locales. The locale
identifiers are provided (base locale ID, common display name) along with the
each locale's group and decimal separator marks. A formatted numeric example
is provided (based on the value of \code{11027}) to demonstrate the default
formatting of each locale.
}
\details{
There are 712 locales, which means that a very long display table is provided
by default. To trim down the output table size, we can provide an initial
letter corresponding to the base locale ID to \code{begins_with}. This will filter
locales in the info table to just the set that begins with the supplied
letter.
}
\section{Examples}{


Get a table of info on all of the locales where the base locale ID begins
with a \code{"v"}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_locales(begins_with = "v")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_locales_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

10-4
}

\seealso{
Other Information Functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_google_fonts}()},
\code{\link{info_paletteer}()},
\code{\link{info_time_style}()}
}
\concept{Information Functions}
