% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_IPV_vs_fNsquared_ratio}
\alias{gsw_IPV_vs_fNsquared_ratio}
\title{Ratio of vert. gradient of pot. density to vert grad of locally-referenced pot density}
\usage{
gsw_IPV_vs_fNsquared_ratio(SA, CT, p, p_ref = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
list containing IPV_vs_fNsquared_ratio [ unitless ] and mid-point pressure p_mid [ dbar ]
}
\description{
Note that the C library had to be patched to get this working; a new
version of the library will address the bug directly.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <-  c(     10,      50,     125,     250,     600,    1000)
p_ref <- 0
r <- gsw_IPV_vs_fNsquared_ratio(SA, CT, p, p_ref)
stopifnot(all.equal(r$IPV_vs_fNsquared_ratio,
    c(0.999742244888022, 0.996939883468178, 0.986141997098021,
      0.931595598713477, 0.861224354872028)))
stopifnot(all.equal(r$p_mid, c(30, 87.5, 187.5, 425, 800)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_IPV_vs_fNsquared_ratio.html}
}
