% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_specvol_ice}
\alias{gsw_specvol_ice}
\title{Specific Volume of Ice}
\usage{
gsw_specvol_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
Specific volume [ m^3/kg ]
}
\description{
Specific Volume of Ice
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,       600,     1000)
v <- gsw_specvol_ice(t, p)
stopifnot(all.equal(v, c(0.001088982980677, 0.001088489459509, 0.001088499019939,
                         0.001088433747301, 0.001088223220685, 0.001088135464776)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_specvol_ice.html}
}
\seealso{
Other things related to density: 
\code{\link{gsw_CT_from_rho}()},
\code{\link{gsw_CT_maxdensity}()},
\code{\link{gsw_SA_from_rho}()},
\code{\link{gsw_alpha_on_beta}()},
\code{\link{gsw_alpha_wrt_t_exact}()},
\code{\link{gsw_alpha_wrt_t_ice}()},
\code{\link{gsw_alpha}()},
\code{\link{gsw_beta_const_t_exact}()},
\code{\link{gsw_beta}()},
\code{\link{gsw_pot_rho_t_exact}()},
\code{\link{gsw_rho_alpha_beta}()},
\code{\link{gsw_rho_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_rho_first_derivatives}()},
\code{\link{gsw_rho_ice}()},
\code{\link{gsw_rho_t_exact}()},
\code{\link{gsw_rho}()},
\code{\link{gsw_sigma0}()},
\code{\link{gsw_sigma1}()},
\code{\link{gsw_sigma2}()},
\code{\link{gsw_sigma3}()},
\code{\link{gsw_sigma4}()},
\code{\link{gsw_specvol_alpha_beta}()},
\code{\link{gsw_specvol_anom_standard}()},
\code{\link{gsw_specvol_t_exact}()},
\code{\link{gsw_specvol}()}
}
\concept{things related to density}
