% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_specvol}
\alias{gsw_specvol}
\title{Specific Volume of Seawater}
\usage{
gsw_specvol(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
Specific volume (1/density)
}
\description{
Specific Volume of Seawater
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p <- c(      10,      50,     125,     250,     600,    1000)
specvol <- gsw_specvol(SA, CT, p)
expect_equal(specvol*1e3, c(0.978626852431313, 0.978222365701325, 0.976155264597929,
                          0.972961258011157, 0.971026719344908, 0.968989944622149))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_specvol.html}
}
\seealso{
Other things related to density: \code{\link{gsw_CT_from_rho}},
  \code{\link{gsw_CT_maxdensity}},
  \code{\link{gsw_SA_from_rho}},
  \code{\link{gsw_alpha_on_beta}},
  \code{\link{gsw_alpha_wrt_t_exact}},
  \code{\link{gsw_alpha_wrt_t_ice}},
  \code{\link{gsw_alpha}},
  \code{\link{gsw_beta_const_t_exact}},
  \code{\link{gsw_beta}},
  \code{\link{gsw_pot_rho_t_exact}},
  \code{\link{gsw_rho_alpha_beta}},
  \code{\link{gsw_rho_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_rho_first_derivatives}},
  \code{\link{gsw_rho_ice}}, \code{\link{gsw_rho_t_exact}},
  \code{\link{gsw_rho}}, \code{\link{gsw_sigma0}},
  \code{\link{gsw_sigma1}}, \code{\link{gsw_sigma2}},
  \code{\link{gsw_sigma3}}, \code{\link{gsw_sigma4}},
  \code{\link{gsw_specvol_alpha_beta}},
  \code{\link{gsw_specvol_anom_standard}},
  \code{\link{gsw_specvol_ice}},
  \code{\link{gsw_specvol_t_exact}}
}
