% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_p_from_z}
\alias{gsw_p_from_z}
\title{Pressure from z}
\usage{
gsw_p_from_z(z, latitude, geo_strf_dyn_height = 0,
  sea_surface_geopotential = 0)
}
\arguments{
\item{z}{height, zero at surface (but note last 2 args) and positive upwards [ m ]}

\item{latitude}{latitude in decimal degrees north [ -90 ... +90 ]}

\item{geo_strf_dyn_height}{dynamic height anomaly [ m^2/s^2 ]}

\item{sea_surface_geopotential}{geopotential at zero sea pressure [ m^2/s^2 ]}
}
\value{
sea pressure [ dbar ]
}
\description{
Pressure from z
}
\examples{
gsw_p_from_z(-10, 4) # 10.05572704136
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_p_from_z.html}
}
\seealso{
This is (almost) the reverse of \code{\link{gsw_z_from_p}}, apart from the last two arguments.
}

