% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_beta}
\alias{gsw_beta}
\title{Saline contraction coefficient at constant Conservative Temperature. (48-term equation)}
\usage{
gsw_beta(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
saline contraction coefficient at constant Conservative Temperature [ kg/g ]
}
\description{
Saline contraction coefficient at constant Conservative Temperature. (48-term equation)
}
\examples{
SA = c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT = c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p =  c(     10,      50,     125,     250,     600,    1000)
beta <- gsw_beta(SA,CT,p)
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_beta.html}
}
\seealso{
The temperature analogue to this is \code{\link{gsw_alpha}}; other related functions
include \code{\link{gsw_alpha_wrt_t_exact}} and \code{\link{gsw_alpha_on_beta}}.
}

