% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_IPV_vs_fNsquared_ratio}
\alias{gsw_IPV_vs_fNsquared_ratio}
\title{Ratio of vert. gradient of pot. density to vert grad of locally-referenced pot density}
\usage{
gsw_IPV_vs_fNsquared_ratio(SA, CT, p, p_ref = 0)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
list containing IPV_vs_fNsquared_ratio [ unitless ] and mid-point pressure p_mid [ dbar ]
}
\description{
Note that the C library had to be patched to get this working; a new
version of the library will address the bug directly.
}
\examples{
SA <- c(34.7118, 34.8915)
CT <- c(28.8099, 28.4392)
p <-  c(     10,      50)
p_ref <- 0
r <- gsw_IPV_vs_fNsquared_ratio(SA, CT, p, p_ref)
r$IPV_vs_fNsquared_ratio # 0.999745283730840
r$p_mid                  # 30
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_IPV_vs_fNsquared_ratio.html}
}

