\name{variogram}
\alias{variogram}
\alias{variogram.gstat}
\alias{variogram.formula}
\alias{variogram.default}
\alias{print.gstatVariogram}
\alias{print.variogramCloud}
\title{ Calculate Sample or Residual Variogram or Variogram Cloud }
\description{
Calculates the sample variogram from data, or in case of a linear model
is given, for the residuals, with options for directional, robust,
and pooled variogram, and for irregular distance intervals.  
}
\synopsis{ variogram(object, ...) }
\usage{
variogram.formula(object, ...)
variogram.gstat(formula, locations, data, ...)
variogram.default(y, locations, X, cutoff, width = cutoff/15, alpha =
	0, beta = 0, tol.hor = 90/length(alpha), tol.ver =
	90/length(beta), cressie = FALSE, dX = numeric(0), boundaries =
	numeric(0), cloud = FALSE, trend.beta = NULL, debug.level = 1,
	cross = TRUE, grid, map = FALSE, ...)

print.gstatVariogram(v, ...)
print.variogramCloud(v, ...)
}
\arguments{
\item{object}{object of class \code{gstat}; in this form, direct
and cross (residual) variograms are calculated for all variables and
variable pairs defined in \code{object}}
\item{formula}{formula defining the response vector and (possible) 
regressors, in case of absence of regressors, use e.g. \code{z~1}}
\item{data}{data frame where the names in formula are to be found}
\item{locations}{ spatial data locations.  For variogram.formula: a
formula with only the coordinate variables in the right hand (explanatory
variable) side e.g. \code{~x+y}; see examples.

For variogram.default: list with coordinate matrices, each with the number
of rows matching that of corresponding vectors in y; the number of columns
should match the number of spatial dimensions spanned by the data (1
(x), 2 (x,y) or 3 (x,y,z)).  }
\item{...}{any other arguments that will be passed to 
\link{variogram.default}}
\item{y}{ list with for each variable the vector with responses }
\item{X}{ (optional) list with for each variable the matrix with
regressors/covariates; the number of rows should match that of the
correspoding element in y, the number of columns equals the number of
regressors (including intercept) }
\item{cutoff}{ spatial separation distance up to which point pairs
are included in semivariance estimates }
\item{width}{ the width of subsequent distance intervals into which
data point pairs are grouped for semivariance estimates }
\item{alpha}{ direction in  plane (x,y), in positive degrees clockwise
from positive y (North): alpha=0 for direction North (increasing y),
alpha=90 for direction East (increasing x); optional a vector of
directions in (x,y) }
\item{beta}{ direction in z, in positive degrees up from the (x,y) plane; }
optional a vector of directions
\item{tol.hor}{ horizontal tolerance angle in degrees }
\item{tol.ver}{ vertical tolerance angle in degrees }
\item{cressie}{ logical; if TRUE, use Cressie's robust variogram estimate;
if FALSE use the classical method of moments variogram estimate }
\item{dX}{ include a pair of data points $y(s_1),y(s_2)$ taken at
locations $s_1$ and $s_2$ for sample variogram calculation only when
$||x(s_1)-x(s_2)|| < dX$ with and $x(s_i)$ the vector with regressors at
location $s_i$, and $||.||$ the 2-norm.  This allows pooled estimation of
within-strata variograms (use a factor variable as regressor, and dX=0.5),
or variograms of (near-)replicates in a linear model (addressing point
pairs having similar values for regressors variables) }
\item{boundaries}{ numerical vector with distance interval boundaries; 
values should be strictly increasing }
\item{cloud}{ logical; if TRUE, calculate the semivariogram cloud }
\item{trend.beta}{vector with trend coefficients, in case they are
known. By default, trend coefficients are estimated from the data.}
\item{debug.level}{ integer; set gstat internal debug level }
\item{cross}{ logical; if FALSE, no cross variograms are calculated
when object is of class \code{gstat} and has more than one variable }
\item{v}{ object of class \code{variogram} or \code{variogramCloud}
to be printed}
\item{grid}{ grid parameters, if data are gridded }
\item{map}{ logical; if TRUE, and \code{cutoff} and \code{width}
are given, a variogram map is returned. This requires package
sp. Alternatively, a map can be passed, of class SpatialDataFrameGrid
(see sp docs) }
% \item{...}{arguments that get passed to \code{print}, e.g. digits}
}
\value{ 
If map is TRUE (or a map is passed), a grid map is returned containing
the (cross) variogram map(s). See package sp.

In other cases, an object of class "gstatVariogram" with the 
following fields:
\item{np}{the number of point pairs for this estimate; 
in case of a \code{variogramCloud} see below}
\item{dist}{the average distance of all point pairs considered
for this estimate}
\item{gamma}{the actual sample variogram estimate}
\item{dir.hor}{the horizontal direction}
\item{dir.ver}{the vertical direction}
\item{id}{the combined id pair}
If cloud is TRUE: an object of class \code{variogramCloud}, with the field
\code{np} encoding the numbers of the point pair that contributed to a
variogram cloud estimate, as follows. The first point is found by the
integer division of np by $2^{16}$, the second point by the remainder
of that division. \link{print.variogramCloud} shows no \code{np} field,
but does show in addition:
\item{left}{for variogramCloud: data id (row number) of one of 
the data pair}
\item{right}{for variogramCloud: data id (row number) of the other 
data in the pair}

In the past, gstat returned an object of class "variogram"; however,
this resulted in confusions for users of the package geoR: the geoR
variog function also returns objects of class "variogram", incompatible
to those returned by this function. That's why I changed the class name.

}

\references{ 
Cressie, N.A.C., 1993, Statistics for Spatial Data, Wiley.

\url{http://www.gstat.org/}

}
\author{ Edzer J. Pebesma }
\note{
}
\seealso{
\link{print.gstatVariogram},
\link{plot.gstatVariogram},
\link{plot.variogramCloud};
for variogram models: \link{vgm},
to fit a variogram model to a sample variogram: 
\link{fit.variogram}
}
\examples{
data(meuse)
# no trend:
variogram(log(zinc)~1, loc=~x+y, meuse)
# residual variogram w.r.t. a linear trend:
variogram(log(zinc)~x+y, loc=~x+y, meuse)
# directional variogram:
variogram(log(zinc)~x+y, loc=~x+y, meuse, alpha=c(0,45,90,135))
}

\keyword{models}
