% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lisiecki2005}
\alias{lisiecki2005}
\title{LR04 Global Pliocene-Pleistocene Benthic d18O Stack (5.3-Myr).}
\format{A data frame with 2115 rows and 3 variables:
\describe{
  \item{Time}{x 1000 years (i.e. ka)}
  \item{d18O}{Benthic d18O (per mil)}
  \item{Error}{Standard error (per mil)}
  ...
}}
\source{
\url{ftp://ftp.ncdc.noaa.gov/pub/data/paleo/contributions_by_author/lisiecki2005/lisiecki2005.txt}
}
\usage{
lisiecki2005
}
\description{
The LR04 stack spans 5.3 Myr and is an average of 57 globally distributed benthic d18O records (which measure global ice volume and deep ocean temperature) collected from the scientific literature. Obtained from ftp://ftp.ncdc.noaa.gov/pub/data/paleo/contributions_by_author/lisiecki2005/lisiecki2005.txt on 28 June 2017
}
\details{
NAME OF DATA SET:
LR04 Global Pliocene-Pleistocene Benthic d18O Stack
LAST UPDATES: 8/2005 (Change number of significant digits in LR04 stack)
7/2005 (final version, 0.64 permil correction for Cibicidoides added)
CONTRIBUTOR: Lorraine E. Lisiecki, Brown University
IGBP PAGES/WDCA CONTRIBUTION SERIES NUMBER: 2005-008

SUGGESTED DATA CITATION:
Lisiecki, L.E. and M.E. Raymo.  2005.
LR04 Global Pliocene-Pleistocene Benthic d18O Stack.
IGBP PAGES/World Data Center for Paleoclimatology
Data Contribution Series #2005-008.
NOAA/NGDC Paleoclimatology Program, Boulder CO, USA.

ORIGINAL REFERENCE:
Lisiecki, L.E. and M.E. Raymo. 2005.
A Pliocene-Pleistocene stack of 57 globally distributed benthic D18O records.
Paleoceanography, Vol. 20, PA1003, doi:10.1029/2004PA001071.

ADDITIONAL REFERENCES:

Imbrie, J., J. D. Hays, D. G. Martinson, A. McIntyre, A. C. Mix, J. J. Morley,
N. G. Pisias, W. L. Prell, and N. J. Shackleton. 1984.
The orbital theory of Pleistocene climate: Support from a revised chronology
of the marine d18O record. in Milankovitch and Climate, Part 1, edited by
A. Berger, pp. 269-305, Springer, New York.

Shackleton, N. J. 1995. New data on the evolution of Pliocene climate variability.
in Paleoclimate and Evolution, With Emphasis on Human Origins,
edited by E. S. Vrba et al.,  pp. 242-248, Yale Univ. Press, New Haven, Ct.

ABSTRACT (Lisiecki and Raymo 2005):
  We present a 5.3-Myr stack (the "LR04" stack) of benthic d18O records
from 57 globally distributed sites aligned by an automated graphic
correlation algorithm. This is the first benthic d18O stack composed of more
than three records to extend beyond 850 ka, and we use its improved signal
quality to identify 24 new marine isotope stages in the early Pliocene.
We also present a new LR04 age model for the Pliocene-Pleistocene derived
from tuning the d18O stack to a simple ice model based on 21 June insolation
at 65N. Stacked sedimentation rates provide additional age model constraints
to prevent overtuning. Despite a conservative tuning strategy, the LR04 benthic
stack exhibits significant coherency with insolation in the obliquity band
throughout the entire 5.3 Myr and in the precession band for more than half
of the record. The LR04 stack contains significantly more variance in benthic
d18O than previously published stacks of the late Pleistocene as the result
of higher resolution records, a better alignment technique, and a greater
percentage of records from the Atlantic. Finally, the relative phases of the
stack’s 41- and 23-kyr components suggest that the precession component of
d18O from 2.7–1.6 Ma is primarily a deep-water temperature signal and that
the phase of d18O precession response changed suddenly at 1.6 Ma.



PERIOD OF RECORD:  5.3 MMYrBP - present

GEOGRAPHIC REGION: Global

DESCRIPTION:
  Lisiecki-Raymo 2004 (LR04) Global Pliocene-Pleistocene Benthic D18O Stack.

The LR04 stack spans 5.3 Myr and was constructed by graphically aligning
57 globally distributed benthic d18O records. Its age model is orbitally tuned
to June 21 insolation at 65N but is also constrained by the average sedimentation
rates of the 57 sites.

LR04 Global Pliocene-Pleistocene Benthic d18O Stack
}
\examples{
names(lisiecki2005)
head(lisiecki2005)
# plot for 0-250 ka:
if (require("ggplot2")) {
   ggplot(lisiecki2005,
          aes(Time,
              d18O)) +
     geom_line() +
     scale_x_continuous(limits = c(0, 250),
                        name = "x 1000 years ago") +
     scale_y_reverse(name = bquote(delta^18*O)) +
     theme_bw()
   }
}
\keyword{datasets}
