% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_bound_summary.R
\name{gs_bound_summary}
\alias{gs_bound_summary}
\title{Bound summary table}
\usage{
gs_bound_summary(
  x,
  digits = 4,
  ddigits = 2,
  tdigits = 0,
  timename = "Month",
  alpha = NULL
)
}
\arguments{
\item{x}{Design object.}

\item{digits}{Number of digits past the decimal to be printed in the body of
the table.}

\item{ddigits}{Number of digits past the decimal to be printed for the
natural parameter delta.}

\item{tdigits}{Number of digits past the decimal point to be shown for
estimated timing of each analysis.}

\item{timename}{Text string indicating time unit.}

\item{alpha}{Vector of alpha values to compute additional efficacy columns.}
}
\value{
A data frame
}
\description{
Summarizes the efficacy and futility bounds for each analysis.
}
\examples{
library(gsDesign2)

x <- gs_design_ahr(info_frac = c(.25, .75, 1), analysis_time = c(12, 25, 36))
gs_bound_summary(x)

x <- gs_design_wlr(info_frac = c(.25, .75, 1), analysis_time = c(12, 25, 36))
gs_bound_summary(x)

# Report multiple efficacy bounds (only supported for AHR designs)
x <- gs_design_ahr(analysis_time = 1:3*12, alpha = 0.0125)
gs_bound_summary(x, alpha = c(0.025, 0.05))

}
\seealso{
\code{\link[gsDesign:gsBoundSummary]{gsDesign::gsBoundSummary()}}
}
