% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.grpreg}
\alias{residuals.grpreg}
\title{Extract residuals from a grpreg or grpsurv fit}
\usage{
\method{residuals}{grpreg}(object, lambda, which = 1:length(object$lambda), drop = TRUE, ...)
}
\arguments{
\item{object}{Object of class \code{grpreg} or \code{grpsurv}.}

\item{lambda}{Values of the regularization parameter at which residuals are requested (numeric vector). For values of lambda not in the sequence of fitted models, linear interpolation is used.}

\item{which}{Index of the penalty parameter at which residuals are requested (default = all indices). If \code{lambda} is specified, this take precedence over \code{which}.}

\item{drop}{By default, if a single value of lambda is supplied, a vector of residuals is returned (logical; default=\code{TRUE}). Set \code{drop=FALSE} if you wish to have the function always return a matrix (see \code{\link[=drop]{drop()}}).}

\item{...}{Not used.}
}
\description{
Currently, only deviance residuals are supported.
}
\examples{
data(Birthwt)
X <- Birthwt$X
y <- Birthwt$bwt
group <- Birthwt$group
fit <- grpreg(X, y, group, returnX=TRUE)
residuals(fit)[1:5, 1:5]
head(residuals(fit, lambda=0.1))
}
