% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{ModvegeEnvironment}
\alias{ModvegeEnvironment}
\title{growR environment data}
\description{
Data structure that contains inputs (parameters pertaining to a site, to
the vegetation, to the weather and to the management) to growR simulations.
}
\details{
This class contains site parameters, weather and management data for
one simulation run of growR on a given site over several years.
Methods are provided to allow access to relevant data for a given year.

All inputs are read in from data files through the respective data classes
\link{WeatherData}, \link{ManagementData} and \link{ModvegeParameters}. These parameters
can be simultaneously specified through a config file using \code{\link[=read_config]{read_config()}}.
}
\seealso{
\code{\link[=read_config]{read_config()}}

\link{WeatherData}\verb{$get_weather_for_year()},
\link{ManagementData}\verb{$get_management_for_year()}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{site_name}}{Name of site to be simulated.}

\item{\code{run_name}}{Name of simulation run. Allows distinguishing between
different simulations at the same site. Defaults to "-" for \emph{no name}.}

\item{\code{run_name_in_filename}}{How the run name will be represented in an
output file. If \code{run_name} is the default "-", indicating no name, this
will be an empty string. Otherwise, it will be the \code{run_name} prepended
by and underscore \verb{_}.}

\item{\code{years}}{Years for which environment data (weather & management) is
present.}

\item{\code{param_file}}{Name of supplied parameter file.}

\item{\code{weather_file}}{Name of supplied weather file.}

\item{\code{management_file}}{Name of supplied management file.}

\item{\code{parameters}}{A \link{ModvegeParameters} object.}

\item{\code{weather}}{A \link{WeatherData} object.}

\item{\code{management}}{A \link{ManagementData} object.}

\item{\code{input_dir}}{Directory in which parameter, weather and management
files are searched for. Defaults to `getOption("growR.input_dir").}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ModvegeEnvironment-new}{\code{ModvegeEnvironment$new()}}
\item \href{#method-ModvegeEnvironment-set_run_name}{\code{ModvegeEnvironment$set_run_name()}}
\item \href{#method-ModvegeEnvironment-load_inputs}{\code{ModvegeEnvironment$load_inputs()}}
\item \href{#method-ModvegeEnvironment-make_filename_for_run}{\code{ModvegeEnvironment$make_filename_for_run()}}
\item \href{#method-ModvegeEnvironment-get_environment_for_year}{\code{ModvegeEnvironment$get_environment_for_year()}}
\item \href{#method-ModvegeEnvironment-clone}{\code{ModvegeEnvironment$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-new"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-new}{}}}
\subsection{Method \code{new()}}{
Instantiate a new ModvegeEnvironment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$new(
  site_name,
  run_name = "-",
  years = NULL,
  param_file = "-",
  weather_file = "-",
  management_file = "-",
  input_dir = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{site_name}}{string Name of the simulated site.}

\item{\code{run_name}}{string Name of the simulation run. Used to
differentiate between different simulation conditions at the same site.
Defaults to "-", which indicates no specific run name.}

\item{\code{years}}{numeric Vector of integer years to be simulated.}

\item{\code{param_file}}{string Name of file that contains site and
vegetation parameters. If default value \code{"-"} is  provided, it is
assumed to be "SITENAME_parameters.csv".}

\item{\code{weather_file}}{string Analogous to \emph{param_file}.}

\item{\code{management_file}}{string Analogous to \emph{param_file}.}

\item{\code{input_dir}}{string Path to directory containing input files.
Defaults to \code{getOption("growR.input_dir")}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-set_run_name"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-set_run_name}{}}}
\subsection{Method \code{set_run_name()}}{
Set run name and update \emph{run_name_in_filename}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$set_run_name(run_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{run_name}}{Str. New value of \code{self$run_name}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-load_inputs"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-load_inputs}{}}}
\subsection{Method \code{load_inputs()}}{
Load simulation inputs.

Stores parameters, management and weather data from files specified in
self$parameter_file, self$weather_file and self$management_file,
respectively.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$load_inputs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-make_filename_for_run"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-make_filename_for_run}{}}}
\subsection{Method \code{make_filename_for_run()}}{
Ensure a readable filename for given \emph{run_name}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$make_filename_for_run(run_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{run_name}}{Name of run to be converted into a filename.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A version of \emph{run_name} that can be used in a filename.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-get_environment_for_year"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-get_environment_for_year}{}}}
\subsection{Method \code{get_environment_for_year()}}{
Get weather and environment for given year

Convenience function to retrieve environmental and management
inputs for given \emph{year} from multi-year data containers \code{self$weather}
and \code{self$management}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$get_environment_for_year(year)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{year}}{int; year for which to extract data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{list(W, M)} where \code{W} is the WeatherData and \code{M} the
ManagementData object for given year.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModvegeEnvironment-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModvegeEnvironment-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModvegeEnvironment$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
