% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_lmer.R
\name{grouped_lmer}
\alias{grouped_lmer}
\title{Running linear mixed-effects model (\code{lmer}) across multiple
grouping variables.}
\usage{
grouped_lmer(data, grouping.vars, formula, REML = TRUE,
  control = lme4::lmerControl(optimizer = "bobyqa", restart_edge = TRUE,
  boundary.tol = 1e-07, calc.derivs = FALSE, use.last.params = FALSE,
  optCtrl = list(maxfun = 2e+09)), p.kr = FALSE, output = "tidy")
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{grouping.vars}{List of grouping variables.}

\item{formula}{a two-sided linear formula object describing both the
    fixed-effects and random-effects part of the model, with the
    response on the left of a \code{~} operator and the terms, separated
    by \code{+} operators, on the right.  Random-effects terms are
    distinguished by vertical bars (\code{|}) separating expressions
    for design matrices from grouping factors.  Two vertical bars
    (\code{||}) can be used to specify multiple uncorrelated random
    effects for the same grouping variable. (Because of the way it is
    implemented, the \code{||}-syntax \emph{works
    only for design matrices containing
    numeric (continuous) predictors}; to fit models with independent
  categorical effects, see \code{\link{dummy}} or the \code{lmer_alt}
  function from the \code{afex} package.) 
}

\item{REML}{logical scalar - Should the estimates be chosen to
    optimize the REML criterion (as opposed to the log-likelihood)?}

\item{control}{a list (of correct class, resulting from
    \code{\link{lmerControl}()} or \code{\link{glmerControl}()}
    respectively) containing control parameters, including the nonlinear
    optimizer to be used and parameters to be passed through to the
    nonlinear optimizer, see the \code{*lmerControl} documentation for
    details.}

\item{p.kr}{Logical, if \code{TRUE}, the computation of p-values is based on
conditional F-tests with Kenward-Roger approximation for the df (see
'Details').}

\item{output}{A character describing what output is expected. Two possible
options: \code{"tidy"} (default), which will return the results, or \code{"glance"},
which will return model summaries.}
}
\value{
A tibble dataframe with tidy results from linear model or model
summaries.
}
\description{
Running linear mixed-effects model (\code{lmer}) across multiple
grouping variables.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# loading libraries containing data
library(ggplot2)
library(gapminder)

# getting tidy output of results
# let's use only subset of the data
groupedstats::grouped_lmer(
  data = dplyr::sample_frac(gapminder, size = 0.5),
  formula = scale(lifeExp) ~ scale(gdpPercap) + (gdpPercap | continent),
  grouping.vars = year,
  output = "tidy"
)

# getting model summaries
groupedstats::grouped_lmer(
  data = ggplot2::diamonds,
  formula = scale(price) ~ scale(carat) + (carat | color),
  REML = FALSE,
  grouping.vars = c(cut, clarity),
  output = "glance"
)
}
}
\author{
Indrajeet Patil
}
