% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/headings.R
\name{alter_column_names}
\alias{alter_column_names}
\title{Alter column names of a grob matrix}
\usage{
alter_column_names(
  mat,
  column_names = list(),
  column_name_cols = list(),
  group_elements = TRUE
)
}
\arguments{
\item{mat}{The grob matrix object the column names will be edited in.}

\item{column_names}{The replacement column names, 
in a list with each column name a separate element. The list must have
the same amount of elements as the \code{column_name_cols} parameter.}

\item{column_name_cols}{Which column positions of the initial data frame / matrix the \code{column_names} 
will replace, in a list with each column name's column positions a separate element. 
The list must have the same amount of elements as the \code{column_names} parameter.

Can either be numeric indices, or column names of the initial data frame / matrix
passed through \code{\link{grob_matrix}}.

Default is an empty list. If unaltered, the function will assume the user
wants to apply \code{column_names} to all columns of the \code{\link{grob_matrix}} - 
in which case only one \code{column_names} is allowed.}

\item{group_elements}{A boolean argument on whether like, adjacent column names 
should be grouped together.}
}
\value{
The initial grob matrix object with column names edited in the appropriate
areas.
}
\description{
Alter column names of an object initialized by \code{\link{grob_matrix}}.
}
\details{
The user can only use this function if the initial data frame / matrix
passed through \code{\link{grob_matrix}} had column names to begin with.

The underlying column names will be unaffected. So, if the user wants to use 
\code{\link{alter_at}} afterwards, he/she should select the original column names
and not the replacements from this function.
}
\examples{

data.frame(var1 = c(5, 14, 6, 10), var2 = c(3, 30, 17, 7)) \%>\%
  grob_matrix() \%>\% 
  alter_column_names(c('COLUMN NAME')) \%>\%
  view_grob()

}
