% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport1d.R, R/transport_cost.R
\name{transport_cost.numeric}
\alias{transport_cost.numeric}
\alias{transport_cost}
\alias{transport_cost.otgridtransport}
\alias{transport_cost.otgrid}
\alias{transport_cost.data.frame}
\title{Optimal Transport Cost}
\usage{
\method{transport_cost}{numeric}(x, y, wx, wy, p = 1, sorted = FALSE, threshold = 1e-15, ...)

transport_cost(x, ...)

\method{transport_cost}{otgridtransport}(x, threshold = 1e-15, ...)

\method{transport_cost}{otgrid}(x, ...)

\method{transport_cost}{data.frame}(x, costm, ...)
}
\arguments{
\item{x}{a vector of points; a data frame with columns \code{from}, \code{to} and \code{mass} specifying the optimal transport plan;
an object of class \code{"otgridtransport"} or \code{"otgrid"}, in the latter case \code{...} must be
the arguments of \code{\link{pivot_measure}}.}

\item{y}{second vector of points.}

\item{wx}{weight vector of the first vector of points.}

\item{wy}{weight vector of the second vector of points.}

\item{p}{the power \eqn{\geq 1} of the cost function.}

\item{sorted}{logical value indicating whether or not \code{a} and \code{b} are sorted.}

\item{threshold}{small value that indicates when a value is considered to be zero.}

\item{...}{further arguments (for \code{\link{pivot_measure}} if \code{x} is an object of class \code{"otgrid"}).}

\item{costm}{cost matrix of the transport}
}
\value{
the optimal transport cost or, in case of two-dimensional case, an object of class \code{"otgridtransport"} with element \code{cost} that contains it.
}
\description{
Calculate the optimal transport cost.
}
\details{
In case of two-dimensional grids, the pivot measure is used to calculate the optimal transport cost.

For one-dimensional optimal transport, the cost function is given by \eqn{c(x, y) = | x - y |^p}. In this case, the north-west-corner
algorithm is used.
}
\examples{
## one-dimensional example
set.seed(1)
a <- 1:5
wa <- rep(1/5, 5)
b <- 1:6
wb <- runif(6)
wb <- wb / sum(wb)
transport_cost(a, b, wa, wb, p = 1)

## two-dimensional example
x <- otgrid(cbind(0:1, 1:0))
y <- otgrid(cbind(1:0, 0:1))

# first calculate pivot manually
pm <- pivot_measure(x, y)
pm <- transport_cost(pm)
print(pm$cost)

# or just
pm2 <- transport_cost(x, y)
print(pm2$cost)

# or from transport plan and cost matrix
costm <- transport_costmat(pm)
tp <- transport_df(pm)
print(transport_cost(tp$df, costm))
}
\seealso{
pivot measure \code{\link{pivot_measure}}
}
