% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_forest.R
\name{predict.regression_forest}
\alias{predict.regression_forest}
\title{Predict with a regression forest}
\usage{
\method{predict}{regression_forest}(object, newdata = NULL,
  num.threads = NULL, estimate.variance = FALSE, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL,
makes out-of-bag predictions on the training set instead
(i.e., provides predictions at Xi using only trees that did
not use the i-th training example).}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{estimate.variance}{Whether variance estimates for hat{tau}(x) are desired
(for confidence intervals).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of predictions.
}
\description{
Gets estimates of E[Y|X=x] using a trained regression forest.
}
\examples{
# Train a standard regression forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
r.forest = regression_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
r.pred = predict(r.forest, X.test)

# Predict on out-of-bag training samples.
r.pred = predict(r.forest)

# Predict with confidence intervals; growing more trees is now recommended.
r.forest = regression_forest(X, Y, num.trees = 100)
r.pred = predict(r.forest, X.test, estimate.variance = TRUE)

}
