% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsrboot.R
\name{dsrboot}
\alias{dsrboot}
\alias{plot.dsrboot}
\title{Data Shape Replication Bootstrap}
\usage{
dsrboot(y, nsim = 100, intermittent = TRUE, type = c("multiplicative",
  "additive"), kind = c("nonparametric", "parametric"), lag = frequency(y),
  sd = NULL, scale = TRUE)

\method{plot}{dsrboot}(x, sorted = FALSE, legend = TRUE, ...)
}
\arguments{
\item{y}{The original time series}

\item{nsim}{Number of iterations (simulations) to run.}

\item{intermittent}{Whether to treat the demand as intermittent or not.}

\item{type}{Type of bootstrap to use. \code{"additive"} means that the randomness is
added, while \code{"multiplicative"} implies the multiplication.}

\item{kind}{A kind of the bootstrap to do: nonparametric or parametric. The latter
relies on the normal distribution, while the former uses the empirical distribution of
differences of the data.}

\item{lag}{The lag to use in the calculation of differences. Should be 1 for non-seasonal
data.}

\item{sd}{Standard deviation to use in the normal distribution. Estimated as mean absolute
differences of the data if omitted.}

\item{scale}{Whether or not to do scaling of time series to the bootstrapped ones to have
similar variance to the original data.}

\item{x}{The object of the class dsrboot.}

\item{sorted}{Whether the sorted (\code{TRUE}) or the original (\code{FALSE})
data should be used.}

\item{legend}{Whether to produce the legend on the plot.}

\item{...}{Other parameters passed to the plot function.}
}
\value{
The function returns:
\itemize{
\item \code{call} - the call that was used originally;
\item \code{data} - the original data used in the function;
\item \code{boot} - the matrix with the new series in columns and observations in rows.
\item \code{type} - type of the bootstrap used.
\item \code{sd} - the value of sd used in case of parameteric bootstrap.
\item \code{scale} - whether the scaling was needed.
\item \code{smooth} - the smoothed ordered actual data.}
}
\description{
The function implements a bootstrap inspired by the Maximum Entropy Bootstrap
}
\details{
The "Data Shape Replication" bootstrap reproduces the shape of the original time series
by creating randomness around it. It is done in the following steps:

1. Sort the data in the ascending order, recording the original order of elements;
2. Take first differences of the original data and sort them;
3. Generate random numbers from the uniform distribution between 0 and 1;
4. Get the smoothed differences that correspond to the random numbers (randomly extract
empirical quantiles). This way we take the empirical density into account when
selecting the differences;
5. Add the random differences to the sorted series from (1) to get a new time series;
6. Sort the new time series in the ascending order;
7. Reorder (6) based on the initial order of series;
8. Centre the data around the original series;
9. Scale the data to make sure that the variance is constant over time.

If the multiplicative bootstrap is used then logarithms of the sorted series
are used and at the very end, the exponent of the resulting data is taken. This way the
discrepancies in the data have similar scale no matter what the level of the original
series is. In case of the additive bootstrap, the trended series will be noisier when
the level of series is low.
}
\examples{
dsrboot(AirPassengers) |> plot()

}
\references{
Vinod HD, López-de-Lacalle J (2009). "Maximum Entropy Bootstrap for Time Series:
The meboot R Package." Journal of Statistical Software, 29(5), 1–19. \doi{doi:10.18637/jss.v029.i05}.
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
