% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmDynamic.R
\name{lmDynamic}
\alias{lmDynamic}
\title{Combine regressions based on point information criteria}
\usage{
lmDynamic(data, ic = c("AICc", "AIC", "BIC", "BICc"), bruteforce = FALSE,
  silent = TRUE, distribution = c("dnorm", "dfnorm", "dlnorm", "dlaplace",
  "ds", "dchisq", "dlogis", "plogis", "pnorm"), parallel = FALSE, ...)
}
\arguments{
\item{data}{Data frame containing dependent variable in the first column and
the others in the rest.}

\item{ic}{Information criterion to use.}

\item{bruteforce}{If \code{TRUE}, then all the possible models are generated
and combined. Otherwise the best model is found and then models around that
one are produced and then combined.}

\item{silent}{If \code{FALSE}, then nothing is silent, everything is printed
out. \code{TRUE} means that nothing is produced.}

\item{distribution}{Distribution to pass to \code{alm()}.}

\item{parallel}{If \code{TRUE}, then the model fitting is done in parallel.
WARNING! Packages \code{foreach} and either \code{doMC} (Linux and Mac only)
or \code{doParallel} are needed in order to run the function in parallel.}

\item{...}{Other parameters passed to \code{alm()}.}
}
\value{
Function returns \code{model} - the final model of the class
"greyboxD", which includes time varying parameters and dynamic importance
of each variable. The list of variables:
\itemize{
\item coefficients - the mean (over time) parameters of the model,
\item vcov - the combined covariance matrix of the model,
\item fitted - the fitted values,
\item residuals - the residuals of the model,
\item distribution - the distribution used in the estimation,
\item logLik - the mean (over time) log-likelihood of the model,
\item IC - dynamic values of the information criterion (pIC),
\item ICType - the type of information criterion used,
\item df.residual - mean number of degrees of freedom of the residuals of
the model,
\item df - mean number of degrees of freedom of the model,
\item importance - dynamic importance of the parameters,
\item call - call used in the function,
\item rank - rank of the combined model,
\item data - the data used in the model,
\item mu - the location value of the distribution,
\item scale - the scale parameter if alm() was used,
\item coefficientsDynamic - table with parameters of the model, varying over
the time,
\item df.residualDynamic - dynamic df.residual,
\item dfDynamic - dynamic df.
\item weights - the dynamic weights for each model under consideration.
}
}
\description{
Function combines parameters of linear regressions of the first variable
on all the other provided data using pAIC weights
}
\details{
The algorithm uses alm() to fit different models and then combines the models
based on the selected point IC. This is a dynamic counterpart of
\link[greybox]{lmCombine} function.

Some details and examples of application are also given in the vignette
"Greybox": \code{vignette("greybox","greybox")}
}
\examples{

### Simple example
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]
# Combine all the possible models
ourModel <- lmDynamic(inSample,bruteforce=TRUE)
predict(ourModel,outSample)
plot(predict(ourModel,outSample))

}
\references{
\itemize{
\item Burnham Kenneth P. and Anderson David R. (2002). Model Selection
and Multimodel Inference. A Practical Information-Theoretic Approach.
Springer-Verlag New York. DOI: [10.1007/b97636](http://dx.doi.org/10.1007/b97636).
}
}
\seealso{
\code{\link[greybox]{stepwise}, \link[greybox]{lmCombine}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
