# Cholesky factor of Wishart should be a lower triangular matrix

    Code
      calculate(chol_x, nsim = 1, seed = 2024 - 10 - 31 - 1338)$chol_x[1, , ]
    Output
               [,1]      [,2]       [,3]
      [1,] 1.205827 -0.283302 -0.2737789
      [2,] 0.000000  1.318010 -2.3508394
      [3,] 0.000000  0.000000  0.2704156

---

    Code
      calc_chol$x[1, , ]
    Output
                [,1]       [,2]       [,3]
      [1,] 2.5280832  0.8034031  3.4674274
      [2,] 0.8034031  4.7851721 -0.8106264
      [3,] 3.4674274 -0.8106264  8.1530456

---

    Code
      calc_chol$chol_x[1, , ]
    Output
               [,1]      [,2]       [,3]
      [1,] 1.589995 0.5052867  2.1807792
      [2,] 0.000000 2.1283462 -0.8986062
      [3,] 0.000000 0.0000000  1.6092714

# Cholesky factor of LJK_correlation should be a lower triangular matrix

    Code
      calculate(chol_x, nsim = 1, seed = 2024 - 7 - 30 - 1431)$chol_x[1, , ]
    Output
           [,1]       [,2]      [,3]
      [1,]    1 -0.1775724 0.2806787
      [2,]    0  0.9841077 0.7509681
      [3,]    0  0.0000000 0.5977177

---

    Code
      calc_chol$x[1, , ]
    Output
                 [,1]       [,2]      [,3]
      [1,]  1.0000000 -0.1775724 0.2806787
      [2,] -0.1775724  1.0000000 0.6891927
      [3,]  0.2806787  0.6891927 1.0000000

---

    Code
      calc_chol$chol_x[1, , ]
    Output
           [,1]       [,2]      [,3]
      [1,]    1 -0.1775724 0.2806787
      [2,]    0  0.9841077 0.7509681
      [3,]    0  0.0000000 0.5977177

# Post-MCMC, Wishart distribution stays symmetric, chol remains lower tri

    Code
      calcs
    Output
      $x
      , , 1
      
               [,1]         [,2]      [,3]
      [1,] 3.104011 -0.009006277 -1.697785
      
      , , 2
      
                   [,1]     [,2]      [,3]
      [1,] -0.009006277 3.009727 -1.500175
      
      , , 3
      
                [,1]      [,2]    [,3]
      [1,] -1.697785 -1.500175 2.25295
      
      
      $`chol(x)`
      , , 1
      
              [,1] [,2] [,3]
      [1,] 1.76182    0    0
      
      , , 2
      
                   [,1]     [,2] [,3]
      [1,] -0.005111915 1.734849    0
      
      , , 3
      
                 [,1]       [,2]      [,3]
      [1,] -0.9636536 -0.8675692 0.7560725
      
      

# Post-MCMC, LKJ distribution stays symmetric, chol remains lower tri

    Code
      calcs
    Output
      $x
      , , 1
      
           [,1]       [,2]      [,3]
      [1,]    1 -0.1775724 0.2806787
      
      , , 2
      
                 [,1] [,2]      [,3]
      [1,] -0.1775724    1 0.6891927
      
      , , 3
      
                [,1]      [,2] [,3]
      [1,] 0.2806787 0.6891927    1
      
      
      $`chol(x)`
      , , 1
      
           [,1] [,2] [,3]
      [1,]    1    0    0
      
      , , 2
      
                 [,1]      [,2] [,3]
      [1,] -0.1775724 0.9841077    0
      
      , , 3
      
                [,1]      [,2]      [,3]
      [1,] 0.2806787 0.7509681 0.5977177
      
      

