% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BS_Malliavin_Asian_Greeks.R
\name{BS_Malliavin_Asian_Greeks}
\alias{BS_Malliavin_Asian_Greeks}
\title{Computes the Greeks of an Asian option with the Malliavin Monte Carlo Method
in the Black Scholes model}
\usage{
BS_Malliavin_Asian_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "rho"),
  steps = round(time_to_maturity * 252),
  paths = 1000,
  seed = 1
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset, can also be a
vector
}}

\item{exercise_price}{\itemize{
\item strike price of the option, can also be a vector
}}

\item{r}{\itemize{
\item risk-free interest rate
}}

\item{time_to_maturity}{\itemize{
\item time to maturity in years
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset
}}

\item{dividend_yield}{\itemize{
\item dividend yield
}}

\item{payoff}{\itemize{
\item the payoff function, either a string in ("call", "put"), or a
function
}}

\item{greek}{\itemize{
\item Greeks to be calculated in c("fair_value", "delta", "gamma",
"gamma_kombi", "rho", "theta", "vega")
}}

\item{steps}{\itemize{
\item the number of integration steps
}}

\item{paths}{\itemize{
\item the number of simulated paths
}}

\item{seed}{\itemize{
\item the seed of the random number generator
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
Computes the Greeks of an Asian option with the Malliavin Monte Carlo Method
in the Black Scholes model
}
\examples{
BS_Malliavin_Asian_Greeks(initial_price = 110, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "rho"), payoff = "put")

}
