% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbm.R
\docType{class}
\name{sbm-class}
\alias{sbm-class}
\title{Stochastic Block Model class}
\description{
An S4 class to represent a Stochastic Block Model, extends \code{\link{icl_model-class}}. 
Such model can be used to cluster graph vertex, and model a square adjacency matrix \eqn{X} with the following generative model :  
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Beta(a_0,b_0)}
\deqn{ X_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{B}(\theta_{kl})}
This class mainly store the prior parameters value \eqn{\alpha,a_0,b_0} of this generative model in the following slots:
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the model}

\item{\code{alpha}}{Dirichlet over cluster proportions prior parameter (default to 1)}

\item{\code{a0}}{Beta prior parameter over links (default to 1)}

\item{\code{b0}}{Beta prior parameter over no-links (default to 1)}

\item{\code{type}}{define the type of networks (either "directed" or "undirected", default to "directed"), for undirected graphs the adjacency matrix is supposed to be symetric.}
}}

\examples{
new("sbm")
new("sbm",a0=0.5, b0= 0.5,alpha=0.5)
sbm = rsbm(100,c(0.5,0.5),diag(2)*0.1+0.01)
sol = greed(sbm$x,model=new("sbm",a0=0.5, b0= 0.5,alpha=0.5))
}
\references{
Nowicki, Krzysztof and Tom A B Snijders (2001). “Estimation and prediction for stochastic block structures”. In:Journal of the American statistical association 96.455, pp. 1077–1087
}
\seealso{
\code{\link{sbm_fit-class}},\code{\link{sbm_path-class}}

\code{\link{greed}}
}
