% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_average_rate.R
\name{inverse_average_rate}
\alias{inverse_average_rate}
\title{Inverse average tax rate}
\usage{
inverse_average_rate(average_rate, ..., .max = 100000000)
}
\arguments{
\item{average_rate}{The average tax rate (\eqn{\frac{tax}{income}})}

\item{...}{Parameters passed to \code{\link{income_tax}}.}

\item{.max}{The maximum income to test before ending the search. (Used only to prevent infinite loops.)}
}
\value{
The minimum income at which the average tax rate exceeds \code{average_rate}.
}
\description{
Inverse average tax rate
}
\examples{
inverse_average_rate(0.2, fy.year = "2014-15")
}
