% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_pc_prec_correl.R
\name{cgeneric_pc_prec_correl}
\alias{cgeneric_pc_prec_correl}
\title{Build an \code{cgeneric} object to implement the PC-prior of a
precision matrix as inverse of a correlation matrix.}
\usage{
cgeneric_pc_prec_correl(
  n,
  lambda,
  theta.base,
  debug = FALSE,
  useINLAprecomp = TRUE,
  shlib = NULL
)
}
\arguments{
\item{n}{integer to define the size of the matrix}

\item{lambda}{numeric (positive), the penalization rate parameter}

\item{theta.base}{numeric vector with the model parameters
at the base model}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'shlib' is provided.}

\item{shlib}{string, default is NULL, with the path to the shared object.}
}
\value{
a \code{cgeneric} object, see \code{\link[INLAtools:cgeneric-class]{INLAtools::cgeneric()}} for details.
}
\description{
Build an \code{cgeneric} object to implement the PC-prior of a
precision matrix as inverse of a correlation matrix.
}
\details{
The Canonical Partial Correlation - CPC parametrization,
Lewandowski, Kurowicka, and Joe (2009).
step 1:  \eqn{q_i} = tanh(\eqn{\theta_i})
step 2:
\deqn{z = \left[
\begin{array}{ccccc}
  1 & & & & \\
  q_1 & 1 & & & \\
  q_2 & q_n & & & \\
  \vdots & & \ldots & \ddots & \\
  q_{n-1} & q_{2n-3} \ldots & q_m & 1
  \end{array}
  \right] }

step 3: compute L such that the correlation matrix is
\deqn{C = LL'}, a \eqn{n \times n} (lower triangle) matrix
\deqn{L_{i,j} = \left\{\begin{array}{cc}
0 & i>j\\
1 & i=j=1\\
z_{i,j} & j=1 \\
prod_{k=1}^{j-1}\sqrt(1-z_{k,j^2}) & 1<i=j \\
z_{i,j}prod_{k=1}^{j-1}\sqrt(1-z_{k,j}^2) &  1<j<i
\end{array}\right.}

The prior of the correlation matrix is given as
\deqn{p(C) = |J_m|*l*exp(-l*r)/(2*pi^(m-1)}
following a bijective transformation from
\deqn{\theta[1:m] \in R^{m} to \{r, \phi[1:(m-1)]\}}
where \eqn{\phi[1:(m-1)]} are angles and
r is the radius of a
\href{https://en.wikipedia.org/wiki/N-sphere}{m-sphere}.
That is
\deqn{r ~ Exponential(\lambda)}
\deqn{\phi[j] ~ Uniform(0, pi), j=1...m-2}
\deqn{\phi[m-1] ~ Uniform(0, 2pi)}
\eqn{J_m} is the Jacobian of this transformation
}
\references{
Lewandowski, Daniel, Dorota Kurowicka, and Harry Joe.
2009. “Generating Random Correlation Matrices Based
on Vines and Extended Onion Method.”
Journal of Multivariate Analysis 100: 1989–2001.
}
