% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence.R
\name{evidence}
\alias{evidence}
\title{Compute Marginal Likelihood using Graphical Evidence}
\usage{
evidence(
  xx,
  burnin,
  nmc,
  prior_name = c("Wishart", "BGL", "GHS", "G_Wishart"),
  runs = 1,
  print_progress = FALSE,
  permute_columns = TRUE,
  alpha = NULL,
  lambda = NULL,
  V = NULL,
  G = NULL
)
}
\arguments{
\item{xx}{The input data specified by a user for which the marginal 
likelihood is to be calculated. This should be input as a matrix like object
with each individual sample of xx representing one row}

\item{burnin}{The number of iterations the MCMC sampler should iterate 
through and discard before beginning to save results}

\item{nmc}{The number of samples that the MCMC sampler should use to estimate
marginal likelihood}

\item{prior_name}{The name of the prior for which the marginal should be 
calculated, this is one of 'Wishart', 'BGL', 'GHS', 'G_Wishart'}

\item{runs}{The number of complete runs of the graphical evidence method that
will be executed. Specifying multiple runs allows estimation of the variance
of the estimator and by default will permute the columns of xx such that 
each run uses a random column ordering, as marginal likelihood should be 
independent of column permutations}

\item{print_progress}{A boolean which indicates whether progress should be 
displayed on the console as each row of the telescoping sum is computed and
each run is completed}

\item{permute_columns}{A boolean which indicates whether columns of xx for
runs beyond the first should be randomly permuted to ensure that 
marginal calculation is consistent across different column permutations}

\item{alpha}{A number specifying alpha for the priors of 'Wishart' and 
'G_Wishart'}

\item{lambda}{A number specifying lambda for the priors of 'BGL' and 'GHS'
prior}

\item{V}{The scale matrix when specifying 'Wishart' or 'G_Wishart' prior}

\item{G}{The adjacency matrix when specifying 'G_Wishart' prior}
}
\value{
A list of results which contains the mean marginal likelihood, the
standard deviation of the estimator, and the raw results in a vector
}
\description{
Computes the marginal likelihood of input data xx under one of the following
priors: Wishart, Bayesian Graphical Lasso (BGL), 
Graphical Horseshoe (GHS), and G-Wishart, specified under prior_name. 
The number of runs is specified by num_runs, where each run is by default
using a random permutation of the columns of xx, as marginal likelihood 
should be independent of column permutation.
}
\examples{
# Compute the marginal 10 times with random column permutations of xx at each
# individual run for G-Wishart prior using 2,000 burnin and 10,000 sampled
# values at each call to the MCMC sampler
g_params <- gen_params_evidence('G_Wishart')
marginal_results <- evidence(
  g_params$x_mat, 2e3, 1e4, 'G_Wishart', 3, alpha=2, 
  V=g_params$scale_mat, G=g_params$g_mat
)
}
