% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{ComputeNonConstantParam}
\alias{ComputeNonConstantParam}
\alias{EvaluateNonConstantParam}
\title{Compute and evaluate functions for non constant rates}
\usage{
ComputeNonConstantParam(start, end = start, exponent = 1, end.time = 2)

EvaluateNonConstantParam(t, param)
}
\arguments{
\item{start}{the value at t=0}

\item{end}{the value at t=end.time}

\item{exponent}{the exponent (e above)}

\item{end.time}{the end time}

\item{t}{vector of times}

\item{param}{output of \code{ComputeNonConstantParam()}, only a single row!}
}
\value{
data frame containing either the parameters o, f and e (ComputeNonConstantParam), or containing the value of $o+f*t^e$ for the given times (EvaluateNonConstantParam).
}
\description{
For simplicity, non constant rates here have the following form $o+f*t^e$.
}
\section{Functions}{
\itemize{
\item \code{ComputeNonConstantParam()}: compute a data frame containing the parameters for non constant rates

\item \code{EvaluateNonConstantParam()}: compute a data frame containing the rates for the given parameter set (computed from \code{ComputeNonConstantParam})

}}
\concept{kinetics}
