% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{ToIndex}
\alias{ToIndex}
\title{Obtain the indices of the given genes}
\usage{
ToIndex(data, gene, regex = FALSE, remove.missing = TRUE)
}
\arguments{
\item{data}{The grandR object}

\item{gene}{A vector of genes. Can be either numeric indices, gene names, gene symbols or a logical vector}

\item{regex}{Treat gene as a regex and return all that match}

\item{remove.missing}{if TRUE, do not return missing genes (return NA otherwise)}
}
\value{
Numeric indices corresponding to the given genes
}
\description{
Genes can be referred to by their names, symbols, row numbers in the gene table, or a logical vector referring to the gene table rows.
This function accepts all these possibilities and returns the row number in the gene table for the given genes,
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))
ToIndex(sars,c("MYC"))
ToIndex(sars,GeneInfo(sars)$Symbol=="MYC")

}
\seealso{
\link{GeneInfo}
}
\concept{helper}
