% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{LikelihoodRatioTest}
\alias{LikelihoodRatioTest}
\title{Compute a likelihood ratio test.}
\usage{
LikelihoodRatioTest(
  data,
  name = "LRT",
  mode = "total",
  slot = "count",
  normalization = mode,
  target = ~Condition,
  background = ~1,
  columns = NULL,
  logFC = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A grandR object}

\item{name}{the user defined analysis name to store the results}

\item{mode}{either "total", "new" or "old"}

\item{slot}{which slot to use (should be a count slot, not normalized values)}

\item{normalization}{normalize on "total", "new", or "old" (see details)}

\item{target}{formula specifying the target model (you can use any column name from the \code{\link{Coldata}(data)})}

\item{background}{formula specifying the background model (you can use any column name from the \code{\link{Coldata}(data)})}

\item{columns}{logical vector of which columns (samples or cells) to use (or NULL: use all)}

\item{logFC}{compute and add the log2 fold change as well}

\item{verbose}{Print status updates}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are
\itemize{
 \item{"M"}{the base mean}
 \item{"S"}{the difference in deviance between the reduced model and the full model}
 \item{"P"}{the likelihood ratio test P value}
 \item{"Q"}{same as P but Benjamini-Hochberg multiple testing corrected}
 \item{"LFC"}{the log2 fold change for the target model (only with the logFC parameter set to TRUE)}
}
}
\description{
The test is computed on any of total/old/new counts using DESeq2 based on two nested models
specified using formulas.
}
\details{
This is a convenience wrapper around the likelihood ratio test implemented in DESeq2.

DESeq2 by default performs size factor normalization. When computing differential expression of new RNA,
it might be sensible to normalize w.r.t. to total RNA, i.e. use the size factors computed from total RNA instead of computed from new RNA.
This can be accomplished by setting mode to "new", and normalization to "total"!
}
\concept{diffexp}
