% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winmove.R
\name{winmove}
\alias{winmove}
\title{Create moving window surface}
\usage{
winmove(fine_dat, d, type = c("circle", "rectangle"), win_fun, ...)
}
\arguments{
\item{fine_dat}{The raster dataset on which to calculate the moving window function}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the
CRS). If \code{type=rectangle} the dimension of the rectangle (one or two numbers).}

\item{type}{The shape of the moving window}

\item{win_fun}{function. The function to apply. If not choosing one of the inbuilt
grainchanger functions, the function should take multiple numbers, and return a
single number. For example \code{mean}, \code{modal}, \code{min} or \code{max}. It should also accept a \code{na.rm}
argument (or ignore it, e.g. as one of the 'dots' arguments. For example, length will
fail, but \code{function(x, ...){na.omit(length(x))}} works. See Details}

\item{...}{further arguments passed to or from other methods}
}
\value{
RasterLayer. A smoothed raster with the moving window values calculated
}
\description{
Smooth a raster surface using a moving window with a given function, radius and shape.
}
\details{
\code{grainchanger} has several built-in functions. Functions currently
  included are: \itemize{ \item \code{wm_shei} - Shannon evenness, requires the
  additional argument \code{lc_class} (vector or scalar) \item \code{wm_prop} -
  Proportion, requires the additional argument \code{lc_class} (scalar) \item
  \code{wm_classes} - Unique number of classes in a categorical landscape \item
  \code{var_range} - Range (max - min) }
}
\examples{
# load required data
data(cat_ls)
data(cont_ls)

# calculate the moving window mean
d <- winmove(cont_ls, 5, "rectangle", mean)

# calculate the moving window Shannon evenness
d <- winmove(cat_ls, 5, "rectangle", shei, lc_class = 1:4)
}
\keyword{focal}
\keyword{spatial}
