% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_api_calls.R
\name{openai_create_edit}
\alias{openai_create_edit}
\title{Create and edit text using OpenAI's API}
\usage{
openai_create_edit(
  model,
  input = "\\"",
  instruction,
  temperature = NULL,
  top_p = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY")
)
}
\arguments{
\item{model}{The model to use for generating text}

\item{input}{The input text to edit}

\item{instruction}{The instruction for editing the text}

\item{temperature}{The temperature to use for generating text (between 0 and
1). If \code{NULL}, the default temperature will be used. It is recommended NOT
to specify temperature and top_p at a time.}

\item{top_p}{The top-p value to use for generating text (between 0 and 1). If
\code{NULL}, the default top-p value will be used. It is recommended NOT to
specify temperature and top_p at a time.}

\item{openai_api_key}{The API key for accessing OpenAI's API. By default, the
function will try to use the \code{OPENAI_API_KEY} environment variable.}
}
\value{
A list with the edited text and other information returned by the
API.
}
\description{
Create and edit text using OpenAI's API
}
\examples{
\dontrun{
openai_create_edit(
  model = "text-davinci-002",
  input = "Hello world!",
  instruction = "Capitalize the first letter of each sentence."
)
}
}
