% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{gpb.Dataset.set.reference}
\alias{gpb.Dataset.set.reference}
\title{Set reference of \code{gpb.Dataset}}
\usage{
gpb.Dataset.set.reference(dataset, reference)
}
\arguments{
\item{dataset}{object of class \code{gpb.Dataset}}

\item{reference}{object of class \code{gpb.Dataset}}
}
\value{
the dataset you passed in
}
\description{
If you want to use validation data, you should set reference to training data
}
\examples{
\donttest{
data(agaricus.train, package ="gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "gpboost")
test <- agaricus.test
dtest <- gpb.Dataset(test$data, test = train$label)
gpb.Dataset.set.reference(dtest, dtrain)
}
}
