% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{timer_check}
\alias{timer_check}
\title{Check the status of a timer}
\usage{
timer_check(timer)
}
\arguments{
\item{timer}{timer object returned by \code{timer_init()}}
}
\value{
logical indicating if timer was triggered. If \code{TRUE}, then 
        the internal state of the timer will be reset (so that it will 
        trigger again after another \code{duraction} has elapsed)
}
\description{
Check the status of a timer
}
\examples{
# Run two timers in a tight while loop
# The short timer should trigger every 0.1 seconds
# The long timer will trigger after 1 second
# Note that the timers will reset every time they trigger (after returning TRUE)
long_timer <- timer_init(1)
short_timer <- timer_init(0.1)
counter <- 0L
while(TRUE) {
  if (timer_check(long_timer)) {
    cat("\nLong  timer fired at count: ", counter, "\n")
    break;
  } 
  if (timer_check(short_timer)) {
    cat("Short timer fired at count: ", counter,  "\n")
  } 
  counter <- counter + 1L
}
}
