% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regret.R
\name{regret}
\alias{regret}
\alias{regret.default}
\alias{regret.pltree}
\alias{regret.list}
\title{Regret-based values for risk assessment}
\usage{
regret(object, ..., bootstrap = TRUE, normalize = TRUE)

\method{regret}{default}(object, ..., values, items, group, bootstrap = TRUE, normalize = TRUE)

\method{regret}{pltree}(object, bootstrap = TRUE, normalize = TRUE, ...)

\method{regret}{list}(object, bootstrap = TRUE, normalize = TRUE, ...)
}
\arguments{
\item{object}{a data.frame, an object of class \code{pltree}, or a 
list with \code{PlackettLuce} models}

\item{...}{further arguments passed to methods}

\item{bootstrap}{logical, to run a bayes bootstrap on \var{object}}

\item{normalize}{logical, to normalize values to sum to 1}

\item{values}{an index in \var{object} with the values to compute regret}

\item{items}{an index in  \var{object} for the different items}

\item{group}{an index in \var{object} for the different scenarios}
}
\value{
A data frame with regret estimates
\item{items}{the item names}
\item{worth}{the worth parameters}
\item{regret}{the squared regret}
\item{worst_regret}{the worst regret}
}
\description{
Regret is an important heuristic in the behavioural sciences. 
Minimizing worst regret (the loss under the worst possible 
outcome) is a criterion that takes a conservative approach 
to risk analysis in diversification strategies.
}
\examples{

# Case 1 ####
library("PlackettLuce")
data("breadwheat", package = "gosset")

# convert the tricot rankings from breadwheat data
# into a object of class 'grouped_rankings'

G <- rank_tricot(breadwheat,
                 items = c("variety_a","variety_b","variety_c"),
                 input = c("overall_best","overall_worst"),
                 group = TRUE)


# combine grouped rankings with temperature indices
mydata <- cbind(G, breadwheat[c("lon","lat")])

# fit a pltree model using geographic data
mod <- pltree(G ~ ., data = mydata)

regret(mod)

# Case 2 ####
# list of PlackettLuce models
R <- matrix(c(1, 2, 3, 0,
              4, 1, 2, 3,
              2, 1, 3, 4,
              1, 2, 3, 0,
              2, 1, 3, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

mod1 <- PlackettLuce(R)

R2 <- matrix(c(1, 2, 0, 3,
               2, 1, 0, 3,
               2, 1, 0, 3,
               1, 2, 0, 3,
               2, 1, 0, 3,
               1, 3, 4, 2), nrow = 6, byrow = TRUE)
colnames(R2) <- c("apple", "banana", "orange", "pear")

mod2 <- PlackettLuce(R2)

mod <- list(mod1, mod2)

regret(mod, n1 = 500)
}
\references{
Loomes G. & Sugden R. (1982). 
The Economic Journal, 92(368), 805. 
\doi{https://doi.org/10.2307/2232669}

Bleichrodt H. & Wakker P. P. (2015). 
The Economic Journal, 125(583), 493–532. 
\doi{https://doi.org/10.1111/ecoj.12200}
}
\author{
Jacob van Etten and Kauê de Sousa
}
