% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layers.R
\name{add_fusion}
\alias{add_fusion}
\title{Add Fusion}
\usage{
add_fusion(map, query, styles = NULL, heatmap = FALSE, layer_id = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{query}{a \code{data.frame} of 2 or 3 columns, and only 1 row. Two columns
must be 'select' and 'from', and the third 'where'. The 'select' value is the column
name (from the fusion table) containing the location information, and the
'from' value is the encrypted table Id. The 'where' value is a string specifying the
'where' condition on the data query.}

\item{styles}{a \code{list} object used to apply colour, stroke weight and
opacity to lines and polygons. See examples to see how the list should be
constructed.}

\item{heatmap}{logical indicating whether to show a heatmap.}

\item{layer_id}{single value specifying an id for the layer.}
}
\description{
Adds a fusion table layer to a map.
}
\examples{
\dontrun{

mapKey <- 'your_api_key'

qry <- data.frame(select = 'address',
    from = '1d7qpn60tAvG4LEg4jvClZbc1ggp8fIGGvpMGzA',
    where = 'ridership > 200')

google_map(key = mapKey, location = c(41.8, -87.7), zoom = 9) \%>\%
  add_fusion(query = qry)



qry <- data.frame(select = 'geometry',
   from = '1ertEwm-1bMBhpEwHhtNYT47HQ9k2ki_6sRa-UQ')

styles <- list(
  list(
    polygonOptions = list( fillColor = "#00FF00", fillOpacity = 0.3)
    ),
  list(
    where = "birds > 300",
    polygonOptions = list( fillColor = "#0000FF" )
    ),
  list(
    where = "population > 5",
    polygonOptions = list( fillOpacity = 1.0 )
 )
)

google_map(key = mapKey, location = c(-25.3, 133), zoom = 4) \%>\%
  add_fusion(query = qry, styles = styles)

qry <- data.frame(select = 'location',
    from = '1xWyeuAhIFK_aED1ikkQEGmR8mINSCJO9Vq-BPQ')

google_map(key = mapKey, location = c(0, 0), zoom = 1) \%>\%
  add_fusion(query = qry, heatmap = T)

}

}

