% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisCoreCharts.R
\name{gvisLineChart}
\alias{gvisLineChart}
\title{Google Line Chart with R
\Sexpr{googleChartName <- "linechart"}
\Sexpr{gvisChartName <- "gvisLineChart"}}
\usage{
gvisLineChart(data, xvar = "", yvar = "", options = list(), chartid)
}
\arguments{
\item{data}{a \code{\link{data.frame}} to be displayed as a line chart}

\item{xvar}{name of the character column which contains the category labels
for the x-axes.}

\item{yvar}{a vector of column names of the numerical variables to be
plotted. Each column is displayed as a separate line.}

\item{options}{list of configuration options, see

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisLineChart function reads a data.frame and creates text output
referring to the Google Visualisation API, which can be included into a web
page, or as a stand-alone page. The actual chart is rendered by the web
browser using SVG or VML.
}
\examples{

## Please note that by default the googleVis plot command
## will open a browser window and requires an internet
## connection to display the visualisation.

df <- data.frame(country=c("US", "GB", "BR"), val1=c(1,3,4), val2=c(23,12,32))

## Line chart
Line1 <- gvisLineChart(df, xvar="country", yvar=c("val1", "val2"))
plot(Line1)


## Add a customised title and smoothed curve
Line2 <- gvisLineChart(df, xvar="country", yvar=c("val1", "val2"),
             options=list(title="Hello World",
                          titleTextStyle="{color:'red',fontName:'Courier',fontSize:16}",
                          curveType='function'))
plot(Line2)

\dontrun{
## Change y-axis to percentages
Line3 <- gvisLineChart(df, xvar="country", yvar=c("val1", "val2"),
                       options=list(vAxis="{format:'#,###\%'}"))
plot(Line3)

}

## Create a chart with two y-axis:
Line4 <-  gvisLineChart(df, "country", c("val1","val2"),
                        options=list(series="[{targetAxisIndex: 0},
                                              {targetAxisIndex:1}]",
                          vAxes="[{title:'val1'}, {title:'val2'}]"
                          ))
plot(Line4)

## Line chart with edit button
Line5 <- gvisLineChart(df, xvar="country", yvar=c("val1", "val2"),
                       options=list(gvis.editor="Edit me!"))
plot(Line5)

## Customizing lines 
Dashed <-  gvisLineChart(df, xvar="country", yvar=c("val1","val2"),
             options=list(
             series="[{color:'green', targetAxisIndex: 0, 
                       lineWidth: 1, lineDashStyle: [2, 2, 20, 2, 20, 2]}, 
                      {color: 'blue',targetAxisIndex: 1, 
                       lineWidth: 2, lineDashStyle: [4, 1]}]",
                       vAxes="[{title:'val1'}, {title:'val2'}]"
                       ))
plot(Dashed)

}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for
printing and plotting methods
}
\keyword{iplot}

