% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{subscriptions_patch}
\alias{subscriptions_patch}
\title{Updates an existing subscription.}
\usage{
subscriptions_patch(
  subscription,
  topic,
  labels = NULL,
  dead_letter_policy = NULL,
  msg_retention_duration = NULL,
  retry_policy = NULL,
  push_config = NULL,
  ack_deadline = NULL,
  expiration_policy = NULL,
  filter = NULL,
  detached = NULL,
  retain_acked_msgs = NULL,
  enable_ordering = NULL
)
}
\arguments{
\item{subscription}{\code{character}, \code{Subscription} Required, a subscription name or a
\code{Subscription} object}

\item{topic}{\code{character}, \code{Topic} Required, a topic name or a \code{Topic} object}

\item{labels}{\code{labels} Key value pairs}

\item{dead_letter_policy}{\code{DeadLetterPolicy} A \code{DeadLetterPolicy} object}

\item{msg_retention_duration}{\code{numeric} How long to retain unacknowledged messages (in seconds)}

\item{retry_policy}{\code{RetryPolicy} policy that specifies how Pub/Sub retries message delivery
for this subscription, can be built with \code{\link{RetryPolicy}}}

\item{push_config}{\code{PushConfig} Can be built with \code{\link{PushConfig}}}

\item{ack_deadline}{\code{numeric} amount of time (in seconds) Pub/Sub waits for the subscriber
to acknowledge receipt before resending the message}

\item{expiration_policy}{\code{ExpirationPolicy} specifies the conditions for this subscription's
expiration. Can be built with \code{\link{ExpirationPolicy}}}

\item{filter}{\code{character} An expression written in the Pub/Sub \href{https://cloud.google.com/pubsub/docs/filtering}{filter language}}

\item{detached}{\code{logical} Indicates whether the subscription is detached from its topic}

\item{retain_acked_msgs}{\code{logical} Indicates whether to retain acknowledged messages}

\item{enable_ordering}{\code{logical}messages published with the same orderingKey in PubsubMessage
will be delivered to the subscribers in the order in which they are received by the Pub/Sub system}
}
\value{
An updated \code{Subscription} object
}
\description{
Certain properties of a subscription, such as its topic, are not modifiable.
}
\seealso{
Other Subscription functions: 
\code{\link{subscriptions_ack}()},
\code{\link{subscriptions_create}()},
\code{\link{subscriptions_delete}()},
\code{\link{subscriptions_detach}()},
\code{\link{subscriptions_exists}()},
\code{\link{subscriptions_get}()},
\code{\link{subscriptions_list}()},
\code{\link{subscriptions_modify_ack_deadline}()},
\code{\link{subscriptions_modify_pushconf}()},
\code{\link{subscriptions_pull}()},
\code{\link{subscriptions_seek}()}
}
\concept{Subscription functions}
