% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vms.R
\name{gce_vm_create}
\alias{gce_vm_create}
\title{Creates an instance resource in the specified project using the data included in the request.}
\usage{
gce_vm_create(name, predefined_type = "f1-micro",
  image_project = "debian-cloud", image_family = "debian-8",
  cpus = NULL, memory = NULL, image = "", disk_source = NULL,
  network = "default", externalIP = NULL, canIpForward = NULL,
  description = NULL, metadata = NULL, scheduling = NULL,
  serviceAccounts = NULL, tags = NULL, minCpuPlatform = NULL,
  project = gce_get_global_project(), zone = gce_get_global_zone(),
  dry_run = FALSE, disk_size_gb = NULL, use_beta = FALSE,
  acceleratorCount = NULL, acceleratorType = "nvidia-tesla-p4")
}
\arguments{
\item{name}{The name of the resource, provided by the client when initially creating the resource}

\item{predefined_type}{A predefined machine type from \link{gce_list_machinetype}}

\item{image_project}{Project ID of where the image lies}

\item{image_family}{Name of the image family to search for}

\item{cpus}{If not defining \code{predefined_type}, the number of CPUs}

\item{memory}{If not defining \code{predefined_type}, amount of memory}

\item{image}{Name of the image resource to return}

\item{disk_source}{Specifies a valid URL to an existing Persistent Disk resource.}

\item{network}{The name of the network interface}

\item{externalIP}{An external IP you have previously reserved, leave NULL to have one assigned or \code{"none"} for no external access.}

\item{canIpForward}{Allows this instance to send and receive packets with non-matching destination or source IPs}

\item{description}{An optional description of this resource}

\item{metadata}{A named list of metadata key/value pairs assigned to this instance}

\item{scheduling}{Scheduling options for this instance, such as preemptible instances}

\item{serviceAccounts}{A list of service accounts, with their specified scopes, authorized for this instance}

\item{tags}{A list of tags to apply to this instance}

\item{minCpuPlatform}{Specify a minimum CPU platform as per \href{these Google docs}{https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform}}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}

\item{dry_run}{whether to just create the request JSON}

\item{disk_size_gb}{If not NULL, override default size of the boot disk (size in GB)}

\item{use_beta}{If set to TRUE will use the beta version of the API. Should not be used for production purposes.}

\item{acceleratorCount}{Number of GPUs to add to instance.  If using this, you may want to instead use \link{gce_vm_gpu} which sets some defaults for GPU instances.}

\item{acceleratorType}{Name of GPU to add, see \link{gce_list_gpus}}
}
\value{
A zone operation, or if the name already exists the VM object from \link{gce_get_instance}
}
\description{
Creates an instance resource in the specified project using the data included in the request.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}

\code{cpus} must be in multiples of 2 up to 32
\code{memory} must be in multiples of 256

One of \code{image} or \code{image_family} must be supplied

To create an instance you need to specify:

\itemize{
  \item Name
  \item Project [if not default]
  \item Zone [if not default]
  \item Machine type - either a predefined type or custom CPU and memory
  \item Network - usually default, specifies open ports etc.
  \item Image - a source image containing the operating system
 }
 
 You can add metadata to the server such as \code{startup-script} and \code{shutdown-script}.  Details available here: \url{https://cloud.google.com/compute/docs/storing-retrieving-metadata}
 
 If you want to not have an external IP then modify the instance afterwards
}
\section{Preemptible VMS}{
 

You can set \href{https://cloud.google.com/compute/docs/instances/create-start-preemptible-instance}{preemptible} VMs by passing this in the \code{scheduling} arguments \code{scheduling = list(preemptible = TRUE)}
 
This creates a VM that may be shut down prematurely by Google - you will need to sort out how to save state if that happens in a shutdown script etc.  However, these are much cheaper.
}

\section{GPUs}{


Some defaults for launching GPU enabled VMs are available at \link{gce_vm_gpu}

You can add GPUs to your instance, but they must be present in the zone you have specified - use \link{gce_list_gpus} to see which are available. Refer to \href{https://cloud.google.com/compute/docs/gpus/#introduction}{this} link for a list of current GPUs per zone.
}

\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}
