% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buckets.R
\name{gcs_create_lifecycle}
\alias{gcs_create_lifecycle}
\title{Create a lifecycle condition}
\usage{
gcs_create_lifecycle(
  age = NULL,
  createdBefore = NULL,
  numNewerVersions = NULL,
  isLive = NULL
)
}
\arguments{
\item{age}{Age in days before objects are deleted}

\item{createdBefore}{Deletes all objects before this date}

\item{numNewerVersions}{Deletes all newer versions of this object}

\item{isLive}{If TRUE deletes all live objects, if FALSE deletes all archived versions

\code{numNewerVersions} and \code{isLive} works only for buckets with object versioning

For multiple conditions, pass this object in as a list.}
}
\description{
Use this to set rules for how long objects last in a bucket in \link{gcs_create_bucket}
}
\examples{
\dontrun{
  lifecycle <- gcs_create_lifecycle(age = 30)
  
  gcs_create_bucket("your-bucket-lifecycle",
                     projectId = "your-project",
                     location = "EUROPE-NORTH1",
                     storageClass = "REGIONAL",
                     lifecycle = list(lifecycle))


}
}
\seealso{
Lifecycle documentation \url{https://cloud.google.com/storage/docs/lifecycle}

Other bucket functions: 
\code{\link{gcs_create_bucket}()},
\code{\link{gcs_delete_bucket}()},
\code{\link{gcs_get_bucket}()},
\code{\link{gcs_get_global_bucket}()},
\code{\link{gcs_global_bucket}()},
\code{\link{gcs_list_buckets}()}
}
\concept{bucket functions}
