% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarGS_assoc_plot.R
\name{VarGS.plot}
\alias{VarGS.plot}
\title{Actual variance vs predicted variance plot}
\usage{
VarGS.plot(
  qt,
  v_score,
  bins = 10,
  xlab = "Predicted variance",
  ylab = "Variance",
  title = ""
)
}
\arguments{
\item{qt}{A numeric vector.}

\item{v_score}{A numeric vector.}

\item{bins}{An integer.}

\item{xlab}{A string.}

\item{ylab}{A string.}

\item{title}{A string.}
}
\value{
A plot comparing predicted variance to actual variance.
}
\description{
This tool creates a line plot that compares the predicted variance of data to its actual variance.
}
\examples{
n_val <- 100000L
v_vec <- exp(rnorm(n_val, 0, 0.1))
qt_vec <- stats::rnorm(n_val, 0, sqrt(v_vec))
VarGS.plot(qt_vec, v_vec)
}
