% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcal.R
\name{unWvec}
\alias{unWvec}
\title{Reverse vectorization operator that restores zeros}
\usage{
unWvec(Wvector, d, structural_pars = NULL)
}
\arguments{
\item{Wvector}{a length \eqn{d^2 - n_zeros} vector where \eqn{n_zeros} is the
number of zero entries in the matrix \code{W}.}

\item{d}{the number of rows in the square matrix to be formed.}

\item{structural_pars}{If \code{NULL} a reduced form model is considered. For structural model, should be a list containing
the following elements:
\itemize{
  \item \code{W} - a \eqn{(dxd)} matrix with its entries imposing constraints on \eqn{W}: \code{NA} indicating that the element is
    unconstrained, a positive value indicating strict positive sign constraint, a negative value indicating strict
    negative sign constraint, and zero indicating that the element is constrained to zero.
  \item \code{C_lambda} - a \eqn{(d(M-1) x r)} constraint matrix that satisfies (\strong{\eqn{\lambda}}\eqn{_{2}}\eqn{,...,}
    \strong{\eqn{\lambda}}\eqn{_{M}) =} \strong{\eqn{C_{\lambda} \gamma}} where \strong{\eqn{\gamma}} is the new \eqn{(r x 1)}
    parameter subject to which the model is estimated (similarly to AR parameter constraints). The entries of \code{C_lambda}
    must be either \strong{positive} or \strong{zero}. Ignore (or set to \code{NULL}) if the eigenvalues \eqn{\lambda_{mi}}
    should not be constrained.
}
See Virolainen (2020) for the conditions required to identify the shocks and for the B-matrix as well (it is \eqn{W} times
a time-varying diagonal matrix with positive diagonal entries).}
}
\value{
a \eqn{(d x d)} matrix \eqn{W}.
}
\description{
\code{unWvec} forms a square matrix from a vector of
  stacked columns where zeros are removed according to structural
  parameter constaints.
}
\section{Warning}{

 No argument checks!
}

\keyword{internal}
