% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{is_stationary}
\alias{is_stationary}
\title{Check the stationary condition of given GMVAR model}
\usage{
is_stationary(p, M, d, params, all_boldA = NULL, tolerance = 0.001)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{number of time series in the system.}

\item{params}{a real valued vector specifying the parameter values. Should be size
\eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
    ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
    \itemize{
      \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
      \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
      \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
    }
Above \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component and \eqn{\alpha_{m}} is the
mixing weight parameter.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
The notations are in line with the cited article by KMS (2016).}

\item{all_boldA}{3D array containing the \eqn{((dp)x(dp))} "bold A" matrices related to each mixture component VAR-process,
obtained from \code{form_boldA}. Will be computed if not given.}

\item{tolerance}{Returns false if modulus of any eigenvalue is larger or equal to \code{1-tolerance}.}
}
\value{
Returns \code{TRUE} if the model is stationary and \code{FALSE} if not. Based on the argument \code{tolerance},
  \code{is_stationary} may return \code{FALSE} when the parameter vector is in the stationarity region, but
  very close to the boundary (this is used to ensure numerical stability in estimation of the model parameters).
}
\description{
\code{is_stationary} checks the stationarity condition of GMVAR model.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
           \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
 }
}
