matrix <- function(data=NA, nrow=1, ncol=1, byrow=FALSE, ...)
  UseMethod("matrix")

matrix.default <- function(...) base::matrix(...)
##
## looks "better", but results wrongly, e.g. matrix(1:6, 3) :
## matrix.default <- function(data = NA, nrow = 1, ncol = 1, byrow = FALSE,
##                            dimnames = NULL, ...)
##     ## here, rightly, any "..." will give an error from base::matrix
##     base::matrix(data, nrow=nrow, ncol=ncol, byrow=byrow,
##                  dimnames=dimnames, ...)

matrix.bigz <- function(data=NA, nrow=1, ncol=1, byrow=FALSE, dimnames=NULL,
                        mod=NA, ...)
  {
    if(!is.null(dimnames))
        warning("'dimnames' are not implemented for this class")
    .Call(as_matrixz, data,
          as.integer(nrow), as.integer(ncol), as.integer(byrow),
          mod)
  }


as.matrix.bigz <- function(x, ...)
{
    if(is.matrix(x) || is.data.frame(x) || inherits(x, "bigz")) {
	d <- dim(x)
	n <- d[1L]
	p <- d[2L]
    } else {
        n <- length(x)
        p <- 1L
    }
    matrix.bigz(x, nrow=n, ncol=p)
}


as.vector.bigz <- function(x, mode="any") {
  attr(x,"nrow") <- NULL
  x
}

t.bigz <- function(x) .Call(bigint_transposeR, x)


##aperm.bigz <- function(a,perm, resize= TRUE)
##  {
##    dims <- dim(a)
##    if (missing(perm))
##      perm <- c(1,2)
##    if(perm[1] > perm[2])
##      ans = .Call("bigint_transposeR",
##        a,
##       PACKAGE="gmp")
##   else
##     ans = a
##    if(!resize)
##      dim(ans) <- dims
##    ans
##}


.dimZQ <- function(x) {
    n <- attr(x,"nrow")
    c(n, length(x)/n)
}

.dimsetZQ <- function(x,value)
{
  stopifnot(value == (v <- as.integer(value)), v >= 0, prod(v) == length(x))
  attr(x,"nrow") <- v[1]
  x
}
.nrowZQ <- function(x) attr(x,"nrow")
## MM: what about 0-row matrices --> ncol(.) gives NaN  ---> proof that we should store 'dim', not 'nrow'
.ncolZQ <- function(x) length(x)/attr(x,"nrow")

dim.bigz <- .dimZQ
dim.bigq <- .dimZQ
`dim<-.bigz` <- .dimsetZQ
`dim<-.bigq` <- .dimsetZQ

nrow.bigz <- .nrowZQ
nrow.bigq <- .nrowZQ
ncol.bigz <- .ncolZQ
ncol.bigq <- .ncolZQ


cbind.bigz <- function(..., recursive = FALSE)
    .Call(biginteger_cbind, list(...))

rbind.bigz <- function(..., recursive = FALSE)
    .Call(biginteger_rbind, list(...))

apply <- function(X, MARGIN, FUN, ...)
    UseMethod("apply")
apply.default <- function(X, MARGIN, FUN, ...)
    base::apply(X, MARGIN, FUN, ...)

apply.bigz <- function(X, MARGIN, FUN, ...)
{
  ## change matrix to a list:
  X <- .Call(gmpMatToListZ, X, as.integer(MARGIN))
  ## then use std lapply() and convert back to vector:
  .Call(biginteger_c, lapply(X, FUN, ...))
}


